// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, Spin;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClose: TButton;
    BSelect: TButton;
    BSetSelection: TButton;
    BFill: TButton;
    BClearSel: TButton;
    BClear: TButton;
    CBoptimized: TCheckBox;
    EAllowedChars: TEdit;
    ESel: TEdit;
    LCBScrollbars: TLabel;
    LSEFrom: TLabel;
    LSEto: TLabel;
    LESel: TLabel;
    LEAllowChars: TLabel;
    LETest: TLabel;
    MTest: TMemo;
    CBReadOnly: TTICheckBox;
    CBEnabled: TTICheckBox;
    SEFrom: TSpinEdit;
    SETill: TSpinEdit;
    CBWantTabs: TTICheckBox;
    CBWordWrap: TTICheckBox;
    CBScrollbars: TTIComboBox;
    procedure BClearClick(Sender: TObject);
    procedure BClearSelClick(Sender: TObject);
    procedure BCloseClick(Sender: TObject);
    procedure BFillClick(Sender: TObject);
    procedure BSelectClick(Sender: TObject);
    procedure BSetSelectionClick(Sender: TObject);
    procedure ETestKeyPress(Sender: TObject; var Key: char);
  private
    procedure FillMemo(B: Boolean);
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SErrSelStartTooBig = 'Selection start larger than text length.';
  SErrSelEndTooBig = 'Selection end larger than text length.';
  SErrTillSmallerThanFrom = 'Selection end before selection start.';
  SFillTime = 'Time to add %d lines: %s';
  
{ TMainForm }

procedure TMainForm.BCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.BClearSelClick(Sender: TObject);
begin
  MTest.ClearSelection;
end;

procedure TMainForm.BClearClick(Sender: TObject);
begin
  MTest.Clear;
end;

procedure TMainForm.BFillClick(Sender: TObject);

begin
  FillMemo(CBOptimized.Checked)
end;

procedure TMainForm.FillMemo(B : Boolean);

Const
  LineCount = 50000;


Var
  I : Integer;
  Start : TDateTime;
  S : String;
  
begin
  Start:=Now;
  With MTest.Lines do
    begin
    If B then
      BeginUpdate;
    try
      Clear;
      For I:=1 to LineCount do
        Add('This is line '+IntToStr(I));
    Finally
      If B then EndUpdate;
    end;
    S:=FormatDateTime('hh:nn:ss.zzz',Now-Start);
    S:=Format(SFillTime,[LineCount,S]);
    ShowMessage(S);
    end;
end;

procedure TMainForm.BSelectClick(Sender: TObject);
begin
  If SEFrom.Value>=Length(MTest.Text) then
    Raise Exception.Create(SErrSelStartTooBig);
  If SETill.Value>=Length(MTest.Text) then
    Raise Exception.Create(SErrSelEndTooBig);
  If SETill.Value<SEFrom.Value then
    Raise Exception.Create(SErrTillSmallerThanFrom);
  MTest.SelStart:=SEFrom.Value;
  MTest.SelLength:=(SEtill.Value-SEFrom.Value);
end;

procedure TMainForm.BSetSelectionClick(Sender: TObject);
begin
  MTest.SelText:=ESel.Text;
end;

procedure TMainForm.ETestKeyPress(Sender: TObject; var Key: char);

Var
  S : String;

begin
  // Only check alphanumerical characters.
  if Upcase(Key) in ['A'..'Z','0'..'9'] then
    begin
    S:=EAllowedChars.Text;
    If (S<>'') and (Pos(Key,S)=0) then
      Key:=#0;
    end;
end;

initialization
  {$I frmmain.lrs}

end.

