// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit songs;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils; 


Type
  TGenre = (gUnknown,gRock,gClassic,gSoul,gPop,gHouse,gFolk,gBlues);

  { TSong }

  TSong = Class(TCollectionItem)
  private
    FAlbum: String;
    FAuthor: String;
    FDuration: TDateTime;
    FGenre: TGenre;
    FTitle: String;
  Published
    Property Author : String Read FAuthor Write FAuthor;
    Property Title : String Read FTitle Write FTitle;
    Property Duration : TDateTime Read FDuration Write FDuration;
    Property Genre : TGenre Read FGenre Write FGenre;
    Property Album : String Read FAlbum Write FAlBum;
  end;
  
  { TSongs }

  TSongs = Class(TCollection)
  private
    function GetSong(Index : Integer): TSong;
    procedure SetSong(Index : Integer; const AValue: TSong);
  Public
    Procedure Populate;
    Property Songs[Index : Integer] : TSong Read GetSong Write SetSong; Default;
  end;
  
implementation

{ TSongs }

Const
  Authors : Array [1..10] of string
          = ('Mozart','Allegri','Rolling Stones','James Brown','Aha',
             'Lais','Beatles','Sade','Cat Power','Right said fred');
  Titles  : Array [1..10] of string
          = ('Requiem','Miserere','Paint it black','I feel good','Take on me',
             'Kanneke','Lucy in the sky with diamonds','Smooth operator',
             'I can get no satisfaction','I''m too sexy');
  Genres  : Array[1..10] of TGenre
          = (gClassic,gclassic,gRock,gSoul,gPop,
             gFolk,gPop,gSoul,gBlues,gpop);
  Durations : Array [1..10] of Integer
            = (70,15,3,5,4,3,3,4,3,2);

function TSongs.GetSong(Index : Integer): TSong;
begin
  Result:=TSong(Items[Index]);
end;

procedure TSongs.SetSong(Index : Integer; const AValue: TSong);
begin
  Items[Index]:=AValue;
end;

procedure TSongs.Populate;

Var
  I,T : Integer;

begin
  For I:=1 to 10 do
    With Add as TSong do
      begin
      Author:=Authors[i];
      Title:=Titles[i];
      Genre:=Genres[i];
      T:=Durations[i];
      Duration:=EncodeTime(T div 60, T mod 60,Random(60),0);
      end;
end;

end.

