// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, FileCtrl, EditBtn;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClear: TButton;
    EDirectory: TDirectoryEdit;
    LEDirectory: TLabel;
    LEMask: TLabel;
    LBtest: TFileListBox;
    LSEItemHeight: TLabel;
    Label2: TLabel;
    LSETopIndex: TLabel;
    LLBtest: TLabel;
    TICheckBox1: TTICheckBox;
    TICheckBox2: TTICheckBox;
    SEItemHeight: TTISpinEdit;
    CBstyle: TTIComboBox;
    CBMultiselect: TTICheckBox;
    CBSorted: TTICheckBox;
    SETopIndex: TTISpinEdit;
    CGFileTypes: TTICheckGroup;
    EMask: TTIEdit;
    procedure BClearClick(Sender: TObject);
    procedure BDeleteClick(Sender: TObject);
    procedure BFillClick(Sender: TObject);
    procedure BaddClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure EDirectoryAcceptDirectory(Sender: TObject; var Value: String);
  private
    procedure FillListBox(B: Boolean);
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SListBox  = 'Listbox demo';
  SAddValue = 'Enter the value to be added to the listbox items';
  

{ TMainForm }

procedure TMainForm.BaddClick(Sender: TObject);

Var
  S : String;

begin
  S:='';
  If InputQuery(SListbox,SAddValue,S) then
    LBTest.Items.Add(S);
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
end;

procedure TMainForm.EDirectoryAcceptDirectory(Sender: TObject; var Value: String
  );
begin
  ShowMessage(Value);
  LBTest.Directory:=Value;
end;

procedure TMainForm.BFillClick(Sender: TObject);
begin
end;

procedure TMainForm.BDeleteClick(Sender: TObject);

begin
end;

procedure TMainForm.BClearClick(Sender: TObject);
begin
  LBtest.Clear;
end;

procedure TMainForm.FillListBox(B : Boolean);

Const
  NoLines = 1000;
  
Var
  I : integer;

begin
  With LBtest.Items do
    begin
    If B then
      BeginUpdate;
    Try
      Clear;
      For I:=1 to NoLines do
        Add('Item number '+IntToStr(i));
    Finally
      If B then
        EndUpdate;
    end;
    end;
end;

initialization
  {$I frmmain.lrs}

end.

