// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, Spin, EditBtn, ExtDlgs;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClose: TButton;
    BSelect: TButton;
    BSetSelection: TButton;
    ETest: TDateEdit;
    EAllowedChars: TEdit;
    ESel: TEdit;
    LCBEchoMode: TLabel;
    Label10: TLabel;
    LECancel: TLabel;
    LEOKCaption: TLabel;
    LEDialogTitle: TLabel;
    LSEMaxLength: TLabel;
    LEpasswordChar: TLabel;
    LSEFrom: TLabel;
    LSETill: TLabel;
    LESel: TLabel;
    LEAllowedChars: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LETest: TLabel;
    LCBCharCase: TLabel;
    CBCharCase: TTIComboBox;
    CBEchoMode: TTIComboBox;
    OPDGlyph: TOpenPictureDialog;
    SEMaxLength: TTISpinEdit;
    CBReadOnly: TTICheckBox;
    CBEnabled: TTICheckBox;
    SEFrom: TSpinEdit;
    SETill: TSpinEdit;
    CBAutoSelect: TTICheckBox;
    EPasswordChar: TTIEdit;
    CBButtonOnlyWhenFocused: TTICheckBox;
    CBDirectInput: TTICheckBox;
    CBFlat: TTICheckBox;
    SEButtonWidth: TTISpinEdit;
    IGLyph: TTIImage;
    TICheckGroup1: TTICheckGroup;
    EDialogTitle: TTIEdit;
    ECancelCaption: TTIEdit;
    EOKCaption: TTIEdit;
    procedure BCloseClick(Sender: TObject);
    procedure BSelectClick(Sender: TObject);
    procedure BSetSelectionClick(Sender: TObject);
    procedure ETestButtonClick(Sender: TObject);
    procedure ETestKeyPress(Sender: TObject; var Key: char);
    procedure IGLyphClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SErrSelStartTooBig = 'Selection start larger than text length.';
  SErrSelEndTooBig = 'Selection end larger than text length.';
  SErrTillSmallerThanFrom = 'Selection end before selection start.';
  SPromptCaption = 'Enter value';
  SPrompt = 'Type the value that should appear in the edit control';
  
{ TMainForm }

procedure TMainForm.BCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.BSelectClick(Sender: TObject);
begin
  If SEFrom.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelStartTooBig);
  If SETill.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelEndTooBig);
  If SETill.Value<SEFrom.Value then
    Raise Exception.Create(SErrTillSmallerThanFrom);
  ETest.SelStart:=SEFrom.Value;
  ETest.SelLength:=(SEtill.Value-SEFrom.Value);
end;

procedure TMainForm.BSetSelectionClick(Sender: TObject);
begin
  ETest.SelText:=ESel.Text;
end;

procedure TMainForm.ETestButtonClick(Sender: TObject);

Var
  S: String;

begin
  S:=ETest.Text;
  If InputQuery(SPromptCaption,SPrompt,S) then
    ETest.Text:=S;
end;

procedure TMainForm.ETestKeyPress(Sender: TObject; var Key: char);

Var
  S : String;

begin
  // Only check alphanumerical characters.
  if Upcase(Key) in ['A'..'Z','0'..'9'] then
    begin
    S:=EAllowedChars.Text;
    If (S<>'') and (Pos(Key,S)=0) then
      Key:=#0;
    end;
end;

procedure TMainForm.IGLyphClick(Sender: TObject);

begin
  With OPDGlyph do
    If Execute then
      begin
      // Only XPM and BMP !
      ETest.Glyph.LoadFromFile(FileName);
      IGlyph.Link.LoadFromProperty;
      end;
end;

initialization
  {$I frmmain.lrs}

end.

