// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit songs;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils; 


Type
  TGenre = (gUnknown,gRock,gClassic,gSoul,gPop,gHouse,gFolk,gBlues);

  { TSong }
  
  { TAuthor }

  TAuthor = Class(TCollectionItem)
  private
    FFirstName: String;
    FIsGroup: Boolean;
    FName: String;
  Published
    Property Name : String Read FName write FName;
    Property FirstName : String Read FFirstName Write FFirstName;
    property IsGroup : Boolean Read FIsGroup Write FIsGroup;
  end;
  
  { TAuthors }

  TAuthors = Class(TCollection)
  private
    function GetAuthor(Index : Integer): TAuthor;
    procedure SetAuthor(Index : Integer; const AValue: TAuthor);
  Public
    Procedure Populate;
    Property Authors[Index : Integer] : TAuthor Read GetAuthor write SetAuthor; Default;
  end;
  

  TSong = Class(TCollectionItem)
  private
    FAlbum: String;
    FAuthor: TAuthor;
    FDuration: TDateTime;
    FGenre: TGenre;
    FTitle: String;
  Published
    Property Author : TAuthor Read FAuthor Write FAuthor;
    Property Title : String Read FTitle Write FTitle;
    Property Duration : TDateTime Read FDuration Write FDuration;
    Property Genre : TGenre Read FGenre Write FGenre;
    Property Album : String Read FAlbum Write FAlBum;
  end;
  
  { TSongs }

  TSongs = Class(TCollection)
  private
    FAuthors: TAuthors;
    function GetSong(Index : Integer): TSong;
    procedure SetSong(Index : Integer; const AValue: TSong);
  Public
    Property Authors : TAuthors Read FAuthors write FAuthors;
    Procedure Populate;
    Property Songs[Index : Integer] : TSong Read GetSong Write SetSong; Default;
  end;
  
implementation

{ TSongs }

Const
  AuthorNames : Array [1..10] of string
          = ('Mozart','Allegri','Rolling Stones','James Brown','Aha',
             'Lais','Beatles','Sade','Cat Power','Right said fred');
  AuthorGroups : Array [1..10] of boolean
          = (False,False,True, False, True,
             True, True, False, False, True);
  Titles  : Array [1..10] of string
          = ('Requiem','Miserere','Paint it black','I feel good','Take on me',
             'Kanneke','Lucy in the sky with diamonds','Smooth operator',
             'I can get no satisfaction','I''m too sexy');
  Genres  : Array[1..10] of TGenre
          = (gClassic,gclassic,gRock,gSoul,gPop,
             gFolk,gPop,gSoul,gBlues,gpop);
  Durations : Array [1..10] of Integer
            = (70,15,3,5,4,3,3,4,3,2);

function TSongs.GetSong(Index : Integer): TSong;
begin
  Result:=TSong(Items[Index]);
end;

procedure TSongs.SetSong(Index : Integer; const AValue: TSong);
begin
  Items[Index]:=AValue;
end;

procedure TSongs.Populate;

Var
  I,T : Integer;

begin
  For I:=1 to 10 do
    With Add as TSong do
      begin
      Author:=Authors[i-1];
      Title:=Titles[i];
      Genre:=Genres[i];
      T:=Durations[i];
      Duration:=EncodeTime(T div 60, T mod 60,Random(60),0);
      end;
end;

{ TAuthors }

function TAuthors.GetAuthor(Index : Integer): TAuthor;
begin
  Result:=TAuthor(Items[Index]);
end;

procedure TAuthors.SetAuthor(Index : Integer; const AValue: TAuthor);
begin
  Items[Index]:=AValue;
end;

procedure TAuthors.Populate;

Var
  I : Integer;

begin
  For I:=1 to 10 do
    With Add as TAuthor do
      begin
      Name:=AuthorNames[i];
      IsGroup:=AuthorGroups[i];
      end;
end;

end.

