// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, CheckLst;

type

  { TMainForm }

  TMainForm = class(TForm)
    BFill: TButton;
    BClear: TButton;
    Badd: TButton;
    BDelete: TButton;
    BShow: TButton;
    BShowSelected: TButton;
    CBoptimized: TCheckBox;
    LBTest: TCheckListBox;
    LSEItemHeight: TLabel;
    Label2: TLabel;
    LSETopIndex: TLabel;
    LLBtest: TLabel;
    TICheckBox1: TTICheckBox;
    SEItemHeight: TTISpinEdit;
    CBstyle: TTIComboBox;
    CBMultiselect: TTICheckBox;
    CBSorted: TTICheckBox;
    SETopIndex: TTISpinEdit;
    procedure BClearClick(Sender: TObject);
    procedure BDeleteClick(Sender: TObject);
    procedure BFillClick(Sender: TObject);
    procedure BShowSelectedClick(Sender: TObject);
    procedure BaddClick(Sender: TObject);
    procedure BShowClick(Sender: TObject);
  private
    procedure FillListBox(B: Boolean);
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SListBox  = 'CheckListbox demo';
  SAddValue = 'Enter the value to be added to the checklistbox items';
  SCheckedItems  = 'The following items were checked:';
  

{ TMainForm }

procedure TMainForm.BaddClick(Sender: TObject);

Var
  S : String;

begin
  S:='';
  If InputQuery(SListbox,SAddValue,S) then
    LBTest.Items.Add(S);
end;

procedure TMainForm.BShowClick(Sender: TObject);

Var
  I : Integer;
  S : String;

begin
  S:=SCheckedItems;
  For I:=0 to LBTest.Items.Count-1 do
    If LBTest.Checked[i] then
      S:=S+sLinebreak+LBTest.Items[i];
  ShowMessage(S);
end;

procedure TMainForm.BFillClick(Sender: TObject);
begin
  FillListBox(CBOptimized.Checked);
end;

procedure TMainForm.BShowSelectedClick(Sender: TObject);

Var
  I : Integer;
  S : String;

begin
  S:=SCheckedItems;
  For I:=0 to LBTest.Items.Count-1 do
    If LBTest.Selected[i] then
      S:=S+sLinebreak+LBTest.Items[i];
  ShowMessage(S);
end;

procedure TMainForm.BDeleteClick(Sender: TObject);

Var
  I : Integer;

begin
  With LBTest do
    if MultiSelect then
      begin
      For I:=Items.Count-1 downto 0 do
        If Selected[i] then
          Items.Delete(I);
      end
    else
      Items.Delete(ItemIndex);
end;

procedure TMainForm.BClearClick(Sender: TObject);
begin
  LBtest.Clear;
end;

procedure TMainForm.FillListBox(B : Boolean);

Const
  NoLines = 1000;
  
Var
  I : integer;

begin
  With LBtest.Items do
    begin
    If B then
      BeginUpdate;
    Try
      Clear;
      For I:=1 to NoLines do
        Add('Item number '+IntToStr(i));
    Finally
      If B then
        EndUpdate;
    end;
    end;
end;

initialization
  {$I frmmain.lrs}

end.

