unit frmmain; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClose: TButton;
    CBEnableHints: TCheckBox;
    CBEnableAccelerator: TCheckBox;
    LBClose: TLabel;
    LHelp: TLabel;
    LButton: TLabel;
    LPos: TLabel;
    LURL: TLabel;
    procedure BCloseClick(Sender: TObject);
    procedure CBEnableAccelleratorChange(Sender: TObject);
    procedure CBEnableHintsChange(Sender: TObject);
    procedure LURLMouseDown(Sender: TOBject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LURLMouseEnter(Sender: TObject);
    procedure LURLMouseLeave(Sender: TObject);
    procedure LURLMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure LURLMouseUp(Sender: TOBject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

{ TMainForm }

Function MouseButtonToString(Button : TMouseButton) : string;

begin
  Case Button of
    mbLeft   : Result:='Left';
    mbRight  : Result:='Right';
    mbMiddle : Result:='Middle';
  end;
end;

Function ShiftStateToString(Shift : TShiftState) : string;

Var
  Names : Array[TShiftStateEnum] of String
        = ('Shift', 'Alt', 'Ctrl',
           'Left', 'Right', 'Middle', 'Double',
           'Meta', 'Super', 'Hyper', 'AltGr', 'Caps', 'Num',
           'Scroll','Triple','Quad','Extra1','Extra2');

Var
  s : TShiftStateEnum;

begin
  Result:='';
  For S:=Low(TShiftStateEnum) to High(TShiftStateEnum) do
    if (S in Shift) then
      begin
      If (result<>'') then
        Result:=Result+',';
      Result:=Result+Names[S];
      end;
end;


procedure TMainForm.LURLMouseEnter(Sender: TObject);
begin
  LURL.Font.Color:=clBlue;
end;

procedure TMainForm.LURLMouseDown(Sender: TOBject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

Var
  S,T : String;
  
begin
  S:=MouseButtonToString(Button);
  S:=format('%s Mouse Button: down at (%d,%d)',[S,X,Y]);
  T:=ShiftStateToString(Shift);
  If (T<>'') then
    S:=S+'Shift: '+T;
  LButton.Caption:=S;
end;

procedure TMainForm.BCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CBEnableAccelleratorChange(Sender: TObject);
begin
  LBClose.ShowAccelChar:=CBEnableAccelerator.Checked;
end;

procedure TMainForm.CBEnableHintsChange(Sender: TObject);
begin
  ShowHint:=CBEnableHints.Checked;
end;

procedure TMainForm.LURLMouseLeave(Sender: TObject);
begin
  LURL.Font.Color:=clBlack;
  LPos.Caption:='Mouse pos:';
  LButton.Caption:='Mouse Button:';
end;

procedure TMainForm.LURLMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
  
Var
  S,T : String;
begin
  S:=Format('Mouse pos: (%d,%d)',[X,Y]);
  T:=ShiftStateToString(Shift);
  If (T<>'') then
    S:=S+'Shift: '+T;
  LPos.Caption:=S;
end;

procedure TMainForm.LURLMouseUp(Sender: TOBject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

Var
  S,T : String;

begin
  S:=MouseButtonToString(Button);
  S:=format('%s Mouse Button: up at (%d,%d)',[S,X,Y]);
  T:=ShiftStateToString(Shift);
  If (T<>'') then
    S:=S+'Shift: '+T;
  LButton.Caption:=S;
end;

initialization
  {$I frmmain.lrs}

end.

