unit frmmain; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, Buttons;

type

  { TMainForm }

  TMainForm = class(TForm)
    BDefault: TButton;
    BCancel: TButton;
    BModalResult: TButton;
    BBitButtons: TButton;
    procedure BBitButtonsClick(Sender: TObject);
    procedure BCancelClick(Sender: TObject);
    procedure BModalResultClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

uses frmmodal,frmbitbuttondemo;

{ TMainForm }

procedure TMainForm.BCancelClick(Sender: TObject);

Var
  Msg : String;

begin
  Case TComponent(Sender).Tag of
    1 : Msg:='Default button pressed';
    2 : Msg:='Cancel button pressed';
  else
    Msg:='Error: Unknown sender !'
  end;
  ShowMessage(Msg);
end;

procedure TMainForm.BBitButtonsClick(Sender: TObject);
begin
  With TBitButtonDemoForm.Create(Self) do
    begin
    Show;
    end;
end;

procedure TMainForm.BModalResultClick(Sender: TObject);

Var
  mr : TModalresult;
  msg : string;
  
begin
  With TModalForm.Create(Self) do
    Try
      mr:=ShowModal;
      msg:=RGModalResult.Items[RGModalResult.ItemIndex];
    finally
      Free;
    end;
  ShowMessage(Format('Result : %d (%s)',[mr,msg]));
end;

initialization
  {$I frmmain.lrs}

end.

